#include "MTTURRViewer.h"
#include "MTFileList.h"
#include "MTUtilities.h"
#include "MTExceptions.h"

MTInfoWindowDataTemplate	MTTURRViewer::kTURRTemplate =
{
	29,
	{
		{	"ID" },				// 0
		{	"Version" },
		{	"Name" },
		{	"Unknown" },
		{	"Unknown" },
		{	"Unknown" },		// 5
		{	"M3GM ID" },
		{	"Unknown" },
		{	"Unknown" },
		{	"M3GM ID" },
		{	"Unknown" },		// 10
		{	"M3GM ID" },
		{	"Unknown" },
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },	// 15
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },	// 20
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },
		{	"Unknown Data" },	// 25
		{	"Unknown Data" },
		{	"Default State" },
		{	"Unknown" }			// 28
	}
};

struct MTTURREntry
{
	char	name[0x10];
	UInt32	data[14];
	UInt32	filler;
};

struct MTTURRFormat
{
	UInt32		id;
	UInt32		version;
	char		name[0x40];
	UInt32		unknown1;
	UInt32		filler1[2];
	UInt16		unknown2;
	UInt16		numEntries;
	UInt16		unknown3;
	UInt16		filler2[3];
	UInt32		m3gmID1;
	UInt32		unknown4;
	UInt32		unknown5;
	UInt32		m3gmID2;
	UInt32		unknown6;
	UInt32		m3gmID3;
	UInt32		unknown7;
	UInt32		data1[6];
	MTTURREntry	entries[0x10];
	UInt16		data2[104];
	char		defaultState[0x20];
	UInt32		unknown8;
};

void MTTURRViewer::ParseData(UInt8 * buf, UInt32 bufSize)
{
	MTTURRFormat	* format;
	char			text[256];
	
	if(bufSize < sizeof(MTTURRFormat))
		throw MTUnsupportedException("Unsupported data structure");
	
	format = (MTTURRFormat *)buf;
	
	SWAP32(format->id);
	SWAP32(format->version);
	SWAP32(format->unknown1);
	SWAP16(format->unknown2);
	SWAP16(format->numEntries);
	SWAP16(format->unknown3);
	SWAP32(format->m3gmID1);
	SWAP32(format->unknown4);
	SWAP32(format->unknown5);
	SWAP32(format->m3gmID2);
	SWAP32(format->unknown6);
	SWAP32(format->m3gmID3);
	SWAP32(format->unknown7);
	SWAP32(format->unknown8);
	
	for(UInt32 i = 0; i < 6; i++)
	{
		SWAP32(format->data1[i]);
		
		data1[i] = format->data1[i];
	}
	
	for(UInt32 i = 0; i < 104; i++)
	{
		SWAP16(format->data2[i]);
		
		data2[i] = format->data2[i];
	}
	
	entries.resize(format->numEntries);
	for(UInt32 i = 0; i < format->numEntries; i++)
	{
		for(UInt32 j = 0; j < 14; j++)
		{
			SWAP32(format->entries[i].data[j]);
			
			entries[i].data[j] = format->entries[i].data[j];
		}
		
		entries[i].name = format->entries[i].name;
	}
	
	id =			format->id;
	version =		format->version;
	name =			format->name;
	unknown1 =		format->unknown1;
	unknown2 =		format->unknown2;
	unknown3 =		format->unknown3;
	m3gmID1 =		format->m3gmID1;
	unknown4 =		format->unknown4;
	unknown5 =		format->unknown5;
	m3gmID2 =		format->m3gmID2;
	unknown6 =		format->unknown6;
	m3gmID3 =		format->m3gmID3;
	unknown7 =		format->unknown7;
	defaultState =	format->defaultState;
	unknown8 =		format->unknown8;
	
	AttachDataTemplate(&kTURRTemplate);
	
	SetNumEntries(29 + (entries.size() * 2));
	
	std::sprintf(text, "%.8X", id);
	SetEntryData(0, text, 0);
	
	std::sprintf(text, "%.8X", version);
	SetEntryData(1, text, 0);
	
	SetEntryData(2, name.c_str(), 0);
	
	std::sprintf(text, "%.8X", unknown1);
	SetEntryData(3, text, 0);
	
	std::sprintf(text, "%.4X", unknown2);
	SetEntryData(4, text, 0);
	
	std::sprintf(text, "%.4X", unknown3);
	SetEntryData(5, text, 0);
	
	std::sprintf(text, "%.8X", m3gmID1);
	SetEntryData(6, text, 0);
	
	std::sprintf(text, "%.8X", unknown4);
	SetEntryData(7, text, 0);
	
	std::sprintf(text, "%.8X", unknown5);
	SetEntryData(8, text, 0);
	
	std::sprintf(text, "%.8X", m3gmID2);
	SetEntryData(9, text, 0);
	
	std::sprintf(text, "%.8X", unknown6);
	SetEntryData(10, text, 0);
	
	std::sprintf(text, "%.8X", m3gmID3);
	SetEntryData(11, text, 0);
	
	std::sprintf(text, "%.8X", unknown7);
	SetEntryData(12, text, 0);
	
	std::sprintf(text, "%.8X %.8X %.8X %.8X %.8X %.8X", data1[0], data1[1], data1[2], data1[3], data1[4], data1[5]);
	SetEntryData(13, text, 0);
	
	for(UInt32 i = 0; i < 13; i++)
	{
		std::sprintf(text,	"%.4X %.4X %.4X %.4X %.4X %.4X %.4X %.4X",
							data2[0 + (i * 8)], data2[1 + (i * 8)], data2[2 + (i * 8)], data2[3 + (i * 8)],
							data2[4 + (i * 8)], data2[5 + (i * 8)], data2[6 + (i * 8)], data2[7 + (i * 8)]);
		SetEntryData(14 + i, text, 0);
	}
	
	SetEntryData(27, defaultState.c_str(), 0);
	
	std::sprintf(text, "%.8X", unknown8);
	SetEntryData(28, text, 0);
	
	for(UInt32 i = 0; i < entries.size(); i++)
	{
		SetEntryData(29 + (i * 2) + 0, entries[i].name.c_str(), 0);
		SetEntryTitle(29 + (i * 2) + 0, "Name", 0);
		
		std::sprintf(text,	"%.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X %.8X",
							entries[i].data[ 0], entries[i].data[ 1], entries[i].data[ 2], entries[i].data[ 3],
							entries[i].data[ 4], entries[i].data[ 5], entries[i].data[ 6], entries[i].data[ 7],
							entries[i].data[ 8], entries[i].data[ 9], entries[i].data[10], entries[i].data[11],
							entries[i].data[12], entries[i].data[13]);
		SetEntryData(29 + (i * 2) + 1, text, 0);
		SetEntryTitle(29 + (i * 2) + 1, "Data", 0);
	}
	
	SetOwnerName("TURR");
	
	DisposePtr((Ptr)buf);
}